<?php namespace App\Controllers\Api\Customer\Payment\Stripe;

use App\Controllers\PrivateController;
use App\Libraries\Settings;
use App\Models\AppsModel;
use App\Models\DepositMethodsModel;
use App\Models\PlansExtraModel;
use App\Models\SubscribesModel;
use App\Models\SubscribesExtraModel;
use CodeIgniter\HTTP\ResponseInterface;
use Stripe\Exception\ApiErrorException;
use Stripe\StripeClient;

require_once(APPPATH . 'ThirdParty/Stripe/init.php');

class CreatePaymentExtraRequest extends PrivateController
{
    /**
     * Create extra plan purchase request with Stripe
     * @return ResponseInterface
     * @throws ApiErrorException
     */
    public function index(): ResponseInterface
    {
        // Validate input
        if (!$this->validate($this->create_validation_type())) {
            return $this->respond(["message" => $this->validator->getErrors()], 400);
        }

        // Get subscription UID and plan extra ID from request
        $subscribe_uid = esc($this->request->getVar("uid"));
            	log_message('debug', 'Received UID: ' . $subscribe_uid);
      	$plan_extra_id = esc($this->request->getVar("plan_extra_id"));
      			log_message('debug', 'Received plan_extra_id: ' . $plan_extra_id);

        // Retrieve app related to subscription
        $subscribes = new SubscribesModel();
        $subscribe = $subscribes
          	->where('uid', $subscribe_uid)
      		->select("app_id")
          	->first();
      
        $projects = new AppsModel();
        $app = $projects->where([
            "id" => $subscribe['app_id'],
          	"user" => $this->userId,
            "deleted_at" => 0
        ])->select("id")->first();

        if (!$app) {
            throw new DatabaseException(lang("Message.message_14"));
        }

        // Retrieve the extra plan
        $plansExtra = new PlansExtraModel();
        $extraPlan = $plansExtra->where([
            "id" => $plan_extra_id,
            "deleted_at" => 0
        ])->first();

        if ($extraPlan['deleted_at'] != 0) {
            throw new DatabaseException(lang("Message.message_99"));
        }

        // Retrieve payment method (Stripe)
        $methods = new DepositMethodsModel();
        $method = $methods->where("id", 1)
                          ->where("status", 1)
                          ->first();

        if (!$method) {
            return $this->respond(["message" => lang("Message.message_84")], 400);
        }

        // Create Stripe session
        $stripe = new StripeClient($method["api_value_1"]);
        $settings = new Settings();
        $frontUrl = $settings->get_config("site_url");

        $session = $stripe->checkout->sessions->create([
            "success_url" => $frontUrl . "private/profile/subscribe",
            "cancel_url"  => $frontUrl . "private/profile/subscribe",
            "mode"        => "payment",
            "line_items"  => [[
                "price"    => $extraPlan["api_id"],
                "quantity" => 1,
            ]],
            "metadata"    => [
              	"type" => "plan_extra",
                "customer_id"   => $this->userId,
                "plan_extra_id" => $extraPlan["id"],
                "app_id"        => $app["id"]
            ]
        ]);

        // Return Stripe session URL to the client
        return $this->respond(["url" => $session->url], 200);
    }

    /**
     * Validation rules for the create extra plan payment
     * @return array
     */
    private function create_validation_type(): array
    {
        return [
            "plan_extra_id" => [
                "label" => lang("Fields.field_160"),
                "rules" => "required|numeric"
            ],
        ];
    }
}
